/*
 * Unix compatibility code. Takes care of some legacy code issues.
 *
 *  Written by Ryan C. Gordon (icculus@clutteredmind.org)
 *
 * Please do NOT harrass Ken Silverman about any code modifications
 *  (including this file) to BUILD.
 */

/*
 * "Build Engine & Tools" Copyright (c) 1993-1997 Ken Silverman
 * Ken Silverman's official web site: "http://www.advsys.net/ken"
 * See the included license file "BUILDLIC.TXT" for license info.
 * This file IS NOT A PART OF Ken Silverman's original release
 */


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>


#include "engine.h"

static FILE    *debugLogFile = NULL;
static FILE    *warningLogFile = NULL;
 
 
void AMIGA_LogInit(void) {
    debugLogFile = fopen("AMIDUKE_LOG.TXT", "w");
    if (debugLogFile) {
        setbuf(debugLogFile, NULL);
    }
}

void AMIGA_LogShutdown(void) {
    if (debugLogFile) {
        fclose (debugLogFile);
        debugLogFile = NULL;
    }

    if (warningLogFile) {
        fclose (warningLogFile);
        warningLogFile = NULL;
    }
} 

long AMIGA_filelength(int fhandle)
{
    long retval = -1;
    struct stat stat_buf;
    if (fstat(fhandle, &stat_buf) == 0)
	retval = (long) stat_buf.st_size;
	
    return(retval);
}

void AMIGA_LogMessage(char *message, ...)
{
    va_list		argptr;
    char		text[1024];
       
    va_start (argptr, message);
    vsprintf (text, message, argptr);
    va_end (argptr);
    
    if (debugLogFile) {
        fwrite(text, 1, strlen(text), debugLogFile);
    } 
}

void AMIGA_LogWarning(char *message, ...)
{
    va_list		argptr;
    char		text[1024];

    va_start (argptr, message);
    vsprintf (text, message, argptr);
    va_end (argptr);    
    
    if (!warningLogFile) {
        warningLogFile = fopen("AMIDUKE_WARNING.TXT", "w");
        if (warningLogFile) {
            setbuf(warningLogFile, NULL);
        }
    }
    
    if (warningLogFile) {
        fwrite(text, 1, strlen(text), warningLogFile);
    }    
} 
  

static int inerror = 0;

void AMIGA_Error(char *message, ...)
{
    va_list		argptr;
    char		text[1024];
    FILE        *errorLogFile = NULL;

   inerror++;
   if (inerror > 1)
      return;

    va_start (argptr, message);
    vsprintf (text, message, argptr);
    va_end (argptr);
    
    // Always create a new file errors (only the first error will ever be logged).
    errorLogFile = fopen("AMIDUKE_ERROR.TXT", "w");
    if (errorLogFile) {
        setbuf(errorLogFile, NULL);
        fwrite(text, 1, strlen(text), errorLogFile);
        fclose (errorLogFile);
        errorLogFile = NULL;
    }

   // Must close down display (so we don't get left with a black screen).
   uninitengine();

   exit(gameexit(EXIT_FAILURE));
}



