/*
 * amiga compatibility header. Takes care of some legacy code issues
 *  and incompatibilities at the source level.
 *
 *  Written by Ryan C. Gordon (icculus@clutteredmind.org)
 *
 * Please do NOT harrass Ken Silverman about any code modifications
 *  (including this file) to BUILD.
 */

/*
 * "Build Engine & Tools" Copyright (c) 1993-1997 Ken Silverman
 * Ken Silverman's official web site: "http://www.advsys.net/ken"
 * See the included license file "BUILDLIC.TXT" for license info.
 * This file IS NOT A PART OF Ken Silverman's original release
 */
  
#ifndef _AMIGA_COMPAT_H_
#define _AMIGA_COMPAT_H_

#if (!defined PLATFORM_AMIGA)
    #error PLATFORM_AMIGA is not defined.
#endif

#if (!defined PLATFORM_TIMER_HZ)
    #define PLATFORM_TIMER_HZ 100
#endif



#ifndef O_BINARY
    #define O_BINARY 0
#endif

#ifdef __GNUC__
typedef long long __int64;
#endif

#define FP_OFF(x) ((long) (x))


#define kmalloc(x) malloc(x)
#define kkmalloc(x) malloc(x)
#define kfree(x) free(x)
#define kkfree(x) free(x)


#ifndef min
    #define min(x, y) ((x) < (y) ? (x) : (y))
#endif

#ifndef max
    #define max(x, y) ((x) > (y) ? (x) : (y))
#endif

#ifndef strcmpi
    #define strcmpi(x, y) strcasecmp(x, y)
#endif


#define PATH_SEP_CHAR '/'
#define PATH_SEP_STR  "/"
#define ROOTDIR       ""
#define CURDIR        ""
#define MAX_PATH 256


#define DEFAULT_DISPLAY_WIDTH   320
#define DEFAULT_DISPLAY_HEIGHT  200

#define MAX_DISPLAY_WIDTH   1600
#define MAX_DISPLAY_HEIGHT  1200


void AMIGA_LogInit(void);
void AMIGA_LogShutdown(void);

void AMIGA_LogMessage(char *message, ...);
void AMIGA_LogWarning(char *message, ...);
void AMIGA_Error(char *message, ...);

long AMIGA_filelength(int fhandle);

#endif // #define _AMIGA_COMPAT_H_





