/*
 * "Build Engine & Tools" Copyright (c) 1993-1997 Ken Silverman
 * Ken Silverman's official web site: "http://www.advsys.net/ken"
 * See the included license file "BUILDLIC.TXT" for license info.
 * This file has been modified from Ken Silverman's original release
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>

#include "build.h"



#define updatecrc16(crc,dat) crc = (((crc<<8)&65535)^crctable[((((unsigned short)crc)>>8)&65535)^dat])



static long crctable[256];


short myconnectindex, numplayers;
short connecthead, connectpoint2[MAXPLAYERS];






void initcrc(void)
{
	long i, j, k, a;

	for(j=0;j<256;j++)      /* Calculate CRC table */
	{
		k = (j<<8); a = 0;
		for(i=7;i>=0;i--)
		{
			if (((k^a)&0x8000) > 0)
				a = ((a<<1)&65535) ^ 0x1021;   /* 0x1021 = genpoly */
			else
				a = ((a<<1)&65535);
			k = ((k<<1)&65535);
		}
		crctable[j] = (a&65535);
	}
}

long getcrc(char *buffer, short bufleng)
{
	long i, j;

	j = 0;
	for(i=bufleng-1;i>=0;i--) updatecrc16(j,buffer[i]);
	return(j&65535);
}

void sendpacket(long other, char *bufptr, long messleng) {}

void genericmultifunction(long other, char *bufptr, long messleng, long command) {}

void setpackettimeout(long datimeoutcount, long daresendagaincount) {}

int getoutputcirclesize(void)
{
	return(0);
}

void sendlogon(void) {}

void sendlogoff(void) {}



void initmultiplayers(char damultioption, char dacomrateoption, char dapriority)
{
	initcrc();
	
	numplayers = 1; myconnectindex = 0;
	connecthead = 0; connectpoint2[0] = -1;  
}

void uninitmultiplayers(void)
{

}






/* end of mmulti.c ... */

