#ifndef _INCLUDE_PLATFORM_H_
#define _INCLUDE_PLATFORM_H_

#if (defined PLATFORM_WIN32)
#include "win32_compat.h"
#elif (defined PLATFORM_UNIX)
#include "unix_compat.h"
#elif (defined PLATFORM_DOS)
#include "doscmpat.h"
#elif (defined PLATFORM_AMIGA)
#include "amiga_compat.h"
#elif (defined PLATFORM_MACOSX)
#include "macosx_compat.h"
#else
#error Define your platform!
#endif


#if ((defined PLATFORM_SUPPORTS_SDL) && (!defined PLATFORM_TIMER_HZ))
#define PLATFORM_TIMER_HZ 1000
#endif

#if (!defined PLATFORM_TIMER_HZ)
#error You need to define PLATFORM_TIMER_HZ for your platform.
#endif



static __inline unsigned short _swap16(unsigned short D)
{
    return (unsigned short)((D<<8)|(D>>8));
}

static __inline unsigned int _swap32(unsigned int D)
{
    return((D<<24)|((D<<8)&0x00FF0000)|((D>>8)&0x0000FF00)|(D>>24));
}

#if PLATFORM_MACOSX
    #define PLATFORM_BIGENDIAN 1
    #define BUILDSWAP_INTEL16(x) _swap16(x)
    #define BUILDSWAP_INTEL32(x) _swap32(x)
#elif PLATFORM_AMIGA
    #define PLATFORM_BIGENDIAN 1
    #define BUILDSWAP_INTEL16(x) _swap16(x)
    #define BUILDSWAP_INTEL32(x) _swap32(x)
#else
    #define PLATFORM_LITTLEENDIAN 1
    #define BUILDSWAP_INTEL16(x) (x)
    #define BUILDSWAP_INTEL32(x) (x)
#endif

#include <time.h>
static inline long Sys_FloatTime(void) {
    return (long)(clock() / 8.33);
} 



#endif  /* !defined _INCLUDE_PLATFORM_H_ */




