#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "dsl.h"
#include "util.h"

#include <exec/exec.h>
#include <proto/ahi.h>
#include <proto/dos.h>
#include <proto/exec.h>


struct Library *AHIBase;
struct MsgPort      *AHImp     = NULL;
struct AHIRequest   *AHIio     = NULL;
BYTE                 AHIDevice = -1;
struct AHIAudioCtrl *actrl     = NULL;






extern int MV_MixPage;

static int DSL_Amiga_ErrorCode = DSL_Ok;

static int mixer_initialized = 0;

static void ( *_CallBackFunc )( void );
static char *_BufferStart;
static int _BufferSize;
static int _SampleRate;
static int _bufferLength;


static unsigned char *buffer;


char *DSL_Amiga_ErrorString( int Amiga_ErrorNumber )
{
	char *Amiga_ErrorString;
	
	switch (Amiga_ErrorNumber) {
		case DSL_Warning:
		case DSL_Amiga_Error:
			Amiga_ErrorString = DSL_Amiga_ErrorString(DSL_Amiga_ErrorCode);
			break;
		
		case DSL_Ok:
			Amiga_ErrorString = "AHI Driver ok.";
			break;
			
		case DSL_MixerAlreadyActive:
			Amiga_ErrorString = "AHI already initialized.";
			break;  
	
		case DSL_MixerInitFailure:
			Amiga_ErrorString = "AHI initialization failed.";
			break;
			
		default:
			Amiga_ErrorString = "Unknown AHI Driver error.";
			break;
	}
	
	return Amiga_ErrorString;
}

static void DSL_SetAmiga_ErrorCode(int Amiga_ErrorCode)
{
	DSL_Amiga_ErrorCode = Amiga_ErrorCode;
}




int DSL_Init( void )
{
    DSL_SetAmiga_ErrorCode(DSL_Ok);
    
    if((AHImp = CreateMsgPort()))
    {
    	if((AHIio = (struct AHIRequest *)CreateIORequest(AHImp,sizeof(struct AHIRequest))))
    	{
    	    if(!(AHIDevice = OpenDevice(AHINAME, AHI_NO_UNIT,(struct IORequest *) AHIio, NULL)))
    	    {
        		AHIBase = (struct Library *) AHIio->ahir_Std.io_Device;
        		return DSL_Ok;
    	    }
    	}
    }
    
    DSL_Shutdown();
    
    DSL_SetAmiga_ErrorCode(DSL_MixerInitFailure);
    return DSL_Amiga_Error;
}

void DSL_Shutdown( void )
{
    DSL_StopPlayback();

    if(actrl)
    {
    	AHI_FreeAudio(actrl);
    	actrl = NULL;
    }

    if( AHIDevice == 0)
    {
    	CloseDevice((struct IORequest *)AHIio);
    	AHIDevice=-1;
    }

    if(AHIio)
    {
    	DeleteIORequest((struct IORequest *)AHIio);
    	AHIio=NULL;
    }

    if(AHImp)
    {
    	DeleteMsgPort(AHImp);
    	AHImp=NULL;
    }
}


static void mixer_callback(struct Hook *hook, struct AHIAudioCtrl *a, APTR bleh)
{
	unsigned char *stptr;
	unsigned char *fxptr;
	int copysize;
	int len;


	/* len should equal _BufferSize, else this is screwed up */
	len = _bufferLength;
	
	
	
    stptr = buffer;

	
	while (len > 0) {
        
		_CallBackFunc();
		
		fxptr = (unsigned char *)(&_BufferStart[MV_MixPage * _BufferSize]);
		
		copysize = min(len, _BufferSize);

		CopyMem(fxptr, stptr, copysize);

		len -= copysize;
		stptr += copysize;
	}
}





struct Hook SoundHook = {
  0,0,
  (ULONG (* )()) mixer_callback,
  NULL,
  NULL,
};






int DSL_BeginBufferedPlayback( char *BufferStart,
      int BufferSize, int NumDivisions, unsigned SampleRate,
      int MixMode, void ( *CallBackFunc )( void ) )
{
	unsigned short format;
    struct AHISampleInfo sample;
    UBYTE modeName[256];
    ULONG obtainedMixingfrequency;
    ULONG sampleCount = 0;
        
	if (mixer_initialized) 
    {
		DSL_SetAmiga_ErrorCode(DSL_MixerAlreadyActive);
		return DSL_Amiga_Error;
	}

	_CallBackFunc = CallBackFunc;
	_BufferStart = BufferStart;
	_BufferSize = (BufferSize / NumDivisions);
	_SampleRate = SampleRate;
	
	

	actrl = AHI_AllocAudio( AHIA_AudioID, AHI_DEFAULT_ID,
				AHIA_MixFreq,SampleRate,
				AHIA_Channels,1,
				AHIA_Sounds, 1,
				AHIA_SoundFunc,(int)&SoundHook,
				TAG_DONE);
	if (!actrl)
	{
        DSL_SetAmiga_ErrorCode(DSL_MixerInitFailure);
        return DSL_Amiga_Error;
    }

    
    AHI_GetAudioAttrs(AHI_INVALID_ID, actrl, AHIDB_BufferLen, 256, AHIDB_Name, (ULONG)&modeName, TAG_END);
    
    // Get real mixing frequency
    AHI_ControlAudio(actrl, AHIC_MixFreq_Query, (int)&obtainedMixingfrequency, TAG_DONE);

    
    // Determine the sample buffer size. We want it to store enough data for
    // at least 1/16th of a second (though at most 8192 samples). Note
    // that it must be a power of two. So e.g. at 22050 Hz, we request a
    // sample buffer size of 2048.
    sampleCount = 8192;
    while ((sampleCount * 16) > (obtainedMixingfrequency * 2)) {
        sampleCount >>= 1;
    } 
    
    _bufferLength = sampleCount * 8; 

    if ((buffer = AllocVec(_bufferLength, MEMF_PUBLIC|MEMF_CLEAR)) == NULL) 
    {
        DSL_SetAmiga_ErrorCode(DSL_MixerInitFailure);
        return DSL_Amiga_Error;
	}
  
    format = (MixMode & SIXTEEN_BIT) ? AHIST_S16S : AHIST_S8S;
    
    sample.ahisi_Type = format;
    sample.ahisi_Address = buffer;
    sample.ahisi_Length = _bufferLength / AHI_SampleFrameSize(format);

    if ((AHI_LoadSound(0, AHIST_SAMPLE, &sample, actrl)) != 0)
    {
        DSL_SetAmiga_ErrorCode(DSL_MixerInitFailure);
        return DSL_Amiga_Error;
    }    
        

    if (AHI_ControlAudio(actrl, AHIC_Play, TRUE, TAG_END) != 0)
    {
        DSL_SetAmiga_ErrorCode(DSL_MixerInitFailure);
        return DSL_Amiga_Error;
    }
    

	AHI_SetFreq(0, obtainedMixingfrequency, actrl, AHISF_IMM);
	AHI_SetVol(0, 0x10000, 0x8000, actrl, AHISF_IMM);
	AHI_SetSound(0, 0, 0, 0, actrl, AHISF_IMM);
	

    AMIGA_LogMessage("AHI audio initialized.\n");
    AMIGA_LogMessage("AHI mode used - %s.\n", modeName);
    AMIGA_LogMessage("AHI settings - %ibit %s @ %d Hz.\n", (MixMode & SIXTEEN_BIT) ? 16 : 8, (MixMode & STEREO) ? "stereo" : "mono", obtainedMixingfrequency);

	mixer_initialized = 1;
	
	return DSL_Ok;
}

void DSL_StopPlayback( void )
{
	if (mixer_initialized) 
    {
        AHI_ControlAudio(actrl, AHIC_Play,FALSE,TAG_DONE);
    	AHI_UnloadSound(0,actrl);

    
    	if (buffer  != NULL)
    	{
            FreeVec(buffer);
    	    buffer = NULL;
    	}
    }
    	
	mixer_initialized = 0;
}

unsigned DSL_GetPlaybackRate( void )
{
	return _SampleRate;
}




