//-------------------------------------------------------------------------
/*
Copyright (C) 1996, 2003 - 3D Realms Entertainment

This file is part of Duke Nukem 3D version 1.5 - Atomic Edition

Duke Nukem 3D is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Original Source: 1996 - Todd Replogle
Prepared for public release: 03/21/2003 - Charlie Wiederhold, 3D Realms
*/
//-------------------------------------------------------------------------





#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "duke3d.h"
#include "scriplib.h"




//
// Sound variables
//
int32 FXDevice;
int32 MusicDevice;
int32 FXVolume;
int32 MusicVolume;
int32 SoundToggle;
int32 MusicToggle;
int32 VoiceToggle;
int32 AmbienceToggle;

int32 NumVoices;
int32 NumChannels;
int32 NumBits;
int32 MixRate;

int32 ReverseStereo;


int32 MouseAiming;


//
// Screen variables
//
int32 ScreenMode;
int32 ScreenWidth;
int32 ScreenHeight;





char *gamefunctions[] =
{
   "Move_Forward",
   "Move_Backward",
   "Turn_Left",
   "Turn_Right",
   "Strafe",
   "Fire",
   "Open",
   "Run",
   "AutoRun",
   "Jump",
   "Crouch",
   "Look_Up",
   "Look_Down",
   "Look_Left",
   "Look_Right",
   "Strafe_Left",
   "Strafe_Right",
   "Aim_Up",
   "Aim_Down",
   "Weapon_1",
   "Weapon_2",
   "Weapon_3",
   "Weapon_4",
   "Weapon_5",
   "Weapon_6",
   "Weapon_7",
   "Weapon_8",
   "Weapon_9",
   "Weapon_10",
   "Inventory",
   "Inventory_Left",
   "Inventory_Right",
   "Holo_Duke",
   "Jetpack",
   "NightVision",
   "MedKit",
   "TurnAround",
   "SendMessage",
   "Map",
   "Shrink_Screen",
   "Enlarge_Screen",
   "Center_View",
   "Holster_Weapon",
   "Show_Opponents_Weapon",
   "Map_Follow_Mode",
   "See_Coop_View",
   "Mouse_Aiming",
   "Toggle_Crosshair",
   "Steroids",
   "Quick_Kick",
   "Next_Weapon",
   "Previous_Weapon",
};





//
// Setup program defines
//
#define SETUPFILENAME "duke3d.cfg"

static char setupfilename[128];
static int32 scripthandle = 0;
static int32 setupread=0;



static char CheckParm (char *check)
{
    int i;
    for (i = 1; i < _argc; i++)
    {
	if ((*(_argv[i]) == '-') && (strcmpi(_argv[i] + 1, check) == 0))
	    return(i);
    }

    return(0);
}


/*
===================
=
= CONFIG_GetSetupFilename
=
===================
*/
#define MAXSETUPFILES 20
void CONFIG_GetSetupFilename( void )
   {
   struct find_t fblock;
   char extension[10];
   char * src;
   char * filenames[MAXSETUPFILES];
   int32 numfiles;
   int32 i;

   GetPathFromEnvironment(setupfilename, 128, SETUPFILENAME);
	
   // determine extension
   src = setupfilename + strlen(setupfilename) - 1;

   while (*src != '.')
   {
      src--;
   }
   strcpy (&extension[1],src);
   extension[0] = '*';

   numfiles=0;
   if (_dos_findfirst(extension,0,&fblock)==0)
   {
      do
	 {
	 // skip timidity.cfg if it exists; it's needed for MIDI playback
	 //  with SDL_mixer, and isn't a Duke configuration file. --ryan.
	 if (strcmpi(fblock.name, "timidity.cfg") != 0)
	    {
	     filenames[numfiles]=malloc(128);
	     strcpy(filenames[numfiles],fblock.name);
	     numfiles++;
	     if (numfiles == MAXSETUPFILES)
		break;
	    }
	 }
      while(!_dos_findnext(&fblock));
      }
   i = CheckParm (SETUPNAMEPARM);
   if (i!=0)
      {
      numfiles = 0;
      strcpy(setupfilename,_argv[i+1]);
      }
   if (numfiles>1)
      {
      int32 time;
      int32 oldtime;
      int32 count;

      printf("\nMultiple Configuration Files Encountered\n");
      printf("========================================\n");
      printf("Please choose a configuration file from the following list by pressing its\n");
      printf("corresponding letter:\n");
      for (i=0;i<numfiles;i++)
	 {
	 if (strcmpi(filenames[i],SETUPFILENAME))
	    {
	    printf("%c. %s\n",'a'+(char)i,filenames[i]);
	    }
	 else
	    {
	    printf("%c. %s <DEFAULT>\n",'a'+(char)i,filenames[i]);
	    }
	 } 
  
      printf("(%s will be used if no selection is made within 10 seconds.)\n\n",SETUPFILENAME);
      KB_FlushKeyboardQueue();
      KB_ClearKeysDown();
      count = 9;
      oldtime = clock();
      time=clock()+(10*CLOCKS_PER_SEC);
      while (clock()<time)
	 {
	 if (clock()>oldtime)
	    {
	    printf("%ld seconds left. \r",count);
	    fflush(stdout);
	    oldtime = clock()+CLOCKS_PER_SEC;
	    count--;
	    }
	 if (KB_KeyWaiting())
	    {
	    int32 ch = KB_Getch();
	    ch -='a';
	    if (ch>=0 && ch<numfiles)
	       {
	       strcpy (setupfilename, filenames[ch]);
	       break;
	       }
	    }
	 }
      printf("\n\n");
      }
   if (numfiles==1)
      strcpy (setupfilename, filenames[0]);
   AMIGA_LogMessage("Using Setup file: '%s'\n",setupfilename);
   i=clock()+(3*CLOCKS_PER_SEC/4);
   while (clock()<i)
      {
      ;
      }
   for (i=0;i<numfiles;i++)
      {
      free(filenames[i]);
      }
   }

/*
===================
=
= CONFIG_FunctionNameToNum
=
===================
*/

int32 CONFIG_FunctionNameToNum( char * func )
{
   int32 i;

   for (i=0;i<NUMGAMEFUNCTIONS;i++)
      {
      if (!stricmp(func,gamefunctions[i]))
	 {
	 return i;
	 }
      }
   return -1;
}

/*
===================
=
= CONFIG_FunctionNumToName
=
===================
*/

char *CONFIG_FunctionNumToName( int32 func )
{
    if (func < NUMGAMEFUNCTIONS)
      {
      return gamefunctions[func];
      }
    else
      {
      return NULL;
      }
}


/*
===================
=
= CONFIG_SetDefaults
=
===================
*/

void CONFIG_SetDefaults( void )
{
   // sound
   SoundToggle = 1;
   MusicToggle = 0;
   VoiceToggle = 1;
   AmbienceToggle = 1;
   FXVolume = 192;
   MusicVolume = 128;
   ReverseStereo = 0;
   
   // game
   ps[0].aim_mode = 0;
   ud.screen_size = 8;
   ud.screen_tilting = 1;
   ud.shadows = 1;
   ud.detail = 1;
   ud.lockout = 0;
   ud.pwlockout[0] = '\0';
   ud.crosshair = 0;
   ud.m_marker = 1;
   ud.m_ffire = 1;
   ud.tickrate = 0;
   
   // TODO - NOVA_CODER - stuff missing here like screen width/height..etc etc
}


static void CONFIG_ReadKeys()
{
   int32 i;
   int32 numkeyentries;
   int32 function;
   char keyname1[80];
   char keyname2[80];
   kb_scancode key1,key2;

   numkeyentries = SCRIPT_NumberEntries( scripthandle, "KeyDefinitions" );

   for (i=0;i<numkeyentries;i++)
      {
      function = CONFIG_FunctionNameToNum(SCRIPT_Entry( scripthandle, "KeyDefinitions", i ));
      if (function != -1)
	 {
	 memset(keyname1,0,sizeof(keyname1));
	 memset(keyname2,0,sizeof(keyname2));
	 SCRIPT_GetDoubleString
	    (
	    scripthandle,
	    "KeyDefinitions",
	    SCRIPT_Entry( scripthandle,"KeyDefinitions", i ),
	    keyname1,
	    keyname2
	    );
	 key1 = 0;
	 key2 = 0;
	 if (keyname1[0])
	    {
	    key1 = (uint8) KB_StringToScanCode( keyname1 );
	    }
	 if (keyname2[0])
	    {
	    key2 = (uint8) KB_StringToScanCode( keyname2 );
	    }
	 CONTROL_MapKey( function, key1, key2 );
	 }
      }
}

static void CONFIG_ReadMouse()
{
    int32 i;
    char str[80];
    char temp[80];
    int32 function;
    
    SCRIPT_GetNumber( scripthandle, "Controls","MouseSensitivity",&function);
    CONTROL_SetMouseSensitivity(function);
    
    SCRIPT_GetNumber( scripthandle, "Controls","AimingFlag",(int32 *)&myaimmode);
    SCRIPT_GetNumber( scripthandle, "Controls","MouseAiming",&MouseAiming);
    SCRIPT_GetNumber( scripthandle, "Controls","MouseAimingFlipped",&ud.mouseflip);
    SCRIPT_GetNumber( scripthandle, "Controls","GameMouseAiming",(int32 *)&ps[0].aim_mode);
    
    for (i=0;i<MAXMOUSEBUTTONS;i++)
    {
        sprintf(str,"MouseButton%ld",i);
        memset(temp,0,sizeof(temp));

        SCRIPT_GetString( scripthandle,"Controls", str,temp);

        function = CONFIG_FunctionNameToNum(temp);
        if (function != -1)
            CONTROL_MapButton( function, i );
    }        
}



void readsavenames(void)
{
    long dummy = 0L;
    short i;
    char filename[] = "game_.sav";
    char fullname[128];
    FILE *fil;

    for (i=0;i<10;i++)
    {
		filename[4] = i+'0';
		GetPathFromEnvironment(fullname, 128, filename);
	
		if ((fil = fopen(fullname,"rb")) == NULL )
			continue;
			
		dfread32(&dummy,1,fil);
		
		if(dummy != BYTEVERSION)
			return;

		dfread32(&dummy,1,fil);
		dfread(&ud.savegame[i][0],19,1,fil);
		fclose(fil);
    }
}

/*
===================
=
= CONFIG_ReadSetup
=
===================
*/
void CONFIG_ReadSetup( void )
{
   int32 dummy;
   char commmacro[] = "CommbatMacro# ";

   if (!SafeFileExists(setupfilename))
   {
      AMIGA_Error("ReadSetup: %s does not exist.", setupfilename);
   }

   CONFIG_SetDefaults();
   scripthandle = SCRIPT_Load( setupfilename );

   for(dummy = 0;dummy < 10;dummy++)
   {
       commmacro[13] = dummy+'0';
       SCRIPT_GetString( scripthandle, "Comm Setup",commmacro,&ud.ridecule[dummy][0]);
   }


   SCRIPT_GetString( scripthandle, "Comm Setup","PlayerName",&myname[0]);

   dummy = CheckParm("NAME");
   
   if( dummy ) strcpy(myname,_argv[dummy+1]);
   {
       dummy = CheckParm("MAP");
   }

#ifndef VOLUMEONE
   if( dummy )
   {
       strcpy(boardfilename,_argv[dummy+1]);
       if( strchr(boardfilename,'.') == 0)
	   strcat(boardfilename,".map");
       AMIGA_LogMessage("Using level: '%s'.\n",boardfilename);
   }
   else
#else
    if( dummyi )
    {
	   AMIGA_Error("The -map option is available in the registered version only!");
    }
#endif
    
   boardfilename[0] = 0;

   SCRIPT_GetString( scripthandle, "Comm Setup","RTSName",&ud.rtsname[0]);
   

   SCRIPT_GetNumber( scripthandle, "Game Setup", "Shadows",&ud.shadows);
   SCRIPT_GetNumber( scripthandle, "Game Setup", "Tilt",&ud.screen_tilting);
   //SCRIPT_GetNumber( scripthandle, "Game Setup", "Cinematics",&ud.showcinematics);
   //SCRIPT_GetNumber( scripthandle, "Game Setup", "HideWeapon",&ud.hideweapon);
   //SCRIPT_GetNumber( scripthandle, "Game Setup", "WeaponSwitch",&ud.weaponautoswitch);
  // SCRIPT_GetNumber( scripthandle, "Game Setup", "AutoAim",&ud.auto_aim);
   SCRIPT_GetNumber( scripthandle, "Game Setup", "AdultMode",&ud.lockout);
   SCRIPT_GetString( scripthandle, "Game Setup", "Password",&ud.pwlockout[0]);
   
   
   CONFIG_ReadKeys();
   CONFIG_ReadMouse();
       

   SCRIPT_GetNumber( scripthandle, "Sound Setup", "FXDevice", &FXDevice);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "MusicDevice",&MusicDevice);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "NumVoices",&NumVoices);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "NumChannels",&NumChannels);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "NumBits",&NumBits);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "MixRate",&MixRate);   
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "FXVolume",&FXVolume);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "MusicVolume",&MusicVolume);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "SoundToggle",&SoundToggle);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "MusicToggle",&MusicToggle);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "VoiceToggle",&VoiceToggle);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "AmbienceToggle",&AmbienceToggle);
   SCRIPT_GetNumber( scripthandle, "Sound Setup", "ReverseStereo",&ReverseStereo);


   SCRIPT_GetNumber( scripthandle, "Screen Setup", "ScreenWidth",&ScreenWidth);
   SCRIPT_GetNumber( scripthandle, "Screen Setup", "ScreenHeight",&ScreenHeight);
   SCRIPT_GetNumber( scripthandle, "Screen Setup", "ScreenMode",&ScreenMode);
   SCRIPT_GetNumber( scripthandle, "Screen Setup", "Detail",&ud.detail);
   SCRIPT_GetNumber( scripthandle, "Screen Setup", "ScreenSize",&ud.screen_size);
   SCRIPT_GetNumber( scripthandle, "Screen Setup", "ScreenGamma",&ud.brightness);
      
   
   SCRIPT_GetNumber( scripthandle, "Misc", "Messages",&ud.fta_on);
   SCRIPT_GetNumber( scripthandle, "Misc", "RunMode",&ud.auto_run);
   SCRIPT_GetNumber( scripthandle, "Misc", "Crosshairs",&ud.crosshair);

   // Weapon choices. 
   if(ud.wchoice[0][0] == 0 && ud.wchoice[0][1] == 0)
   {
       ud.wchoice[0][0] = 3;
       ud.wchoice[0][1] = 4;
       ud.wchoice[0][2] = 5;
       ud.wchoice[0][3] = 7;
       ud.wchoice[0][4] = 8;
       ud.wchoice[0][5] = 6;
       ud.wchoice[0][6] = 0;
       ud.wchoice[0][7] = 2;
       ud.wchoice[0][8] = 9;
       ud.wchoice[0][9] = 1;

       for(dummy=0;dummy<10;dummy++)
       {
	       sprintf(buf,"WeaponChoice%ld",dummy);
	       SCRIPT_GetNumber( scripthandle, "Misc", buf, &ud.wchoice[0][dummy]);
       }
    }
   

   setupread = 1;
}


static void CONFIG_WriteKeys()
{
   int32 dummy;
   
   // write keys
   for(dummy=0; dummy<NUMGAMEFUNCTIONS; dummy++)
   {
		SCRIPT_PutDoubleString(
			scripthandle,
			"KeyDefinitions",
			gamefunctions[dummy],
			KB_ScanCodeToString( KeyMapping[dummy].key1 )?KB_ScanCodeToString( KeyMapping[dummy].key1 ):"",
			KB_ScanCodeToString( KeyMapping[dummy].key2 )?KB_ScanCodeToString( KeyMapping[dummy].key2 ):"");
	}
}

static void CONFIG_WriteMouse()
{
   int32 dummy;
   
   dummy = CONTROL_GetMouseSensitivity();
   SCRIPT_PutNumber( scripthandle, "Controls","MouseSensitivity",dummy,false,false);
   
   SCRIPT_PutNumber( scripthandle, "Controls", "AimingFlag",(long) myaimmode,false,false);
   SCRIPT_PutNumber( scripthandle, "Controls", "MouseAiming",MouseAiming,false,false);
   SCRIPT_PutNumber( scripthandle, "Controls", "MouseAimingFlipped",ud.mouseflip,false,false);
   SCRIPT_PutNumber( scripthandle, "Controls", "GameMouseAiming",(int32) ps[myconnectindex].aim_mode,false,false);
   
   // write mouse buttons
   for(dummy=0; dummy<MAXMOUSEBUTTONS; dummy++)
   {
        sprintf((char *)tempbuf, "MouseButton%d", dummy);
        SCRIPT_PutString(scripthandle, "Controls", (char *)tempbuf,
        	(MouseMapping[dummy]!=-1)?CONFIG_FunctionNumToName(MouseMapping[dummy]):"");
   }
}

/*
===================
=
= CONFIG_WriteSetup
=
===================
*/
void CONFIG_WriteSetup( void )
{
   int32 dummy;

   if (!setupread) return;

   SCRIPT_PutNumber( scripthandle, "Game Setup", "Shadows",ud.shadows,false,false);
   SCRIPT_PutNumber( scripthandle, "Game Setup", "Tilt",ud.screen_tilting,false,false);
   //SCRIPT_PutNumber( scripthandle, "Game Setup", "Cinematics",ud.showcinematics,false,false);
   //SCRIPT_PutNumber( scripthandle, "Game Setup", "HideWeapon",ud.hideweapon,false,false);
   //SCRIPT_PutNumber( scripthandle, "Game Setup", "WeaponSwitch",ud.weaponautoswitch,false,false);
   //SCRIPT_PutNumber( scripthandle, "Game Setup", "AutoAim",ud.auto_aim,false,false);
   SCRIPT_PutNumber( scripthandle, "Game Setup", "AdultMode",ud.lockout,false,false);
   SCRIPT_PutString( scripthandle, "Game Setup", "Password",ud.pwlockout);
   
   CONFIG_WriteKeys();
   CONFIG_WriteMouse();
   
   
   SCRIPT_PutNumber( scripthandle, "Sound Setup", "FXVolume",FXVolume,false,false);
   SCRIPT_PutNumber( scripthandle, "Sound Setup", "MusicVolume",MusicVolume,false,false);
   SCRIPT_PutNumber( scripthandle, "Sound Setup", "SoundToggle",SoundToggle,false,false);
   SCRIPT_PutNumber( scripthandle, "Sound Setup", "MusicToggle",MusicToggle,false,false);
   SCRIPT_PutNumber( scripthandle, "Sound Setup", "VoiceToggle",VoiceToggle,false,false);
   SCRIPT_PutNumber( scripthandle, "Sound Setup", "AmbienceToggle",AmbienceToggle,false,false);
   SCRIPT_PutNumber( scripthandle, "Sound Setup", "ReverseStereo",ReverseStereo,false,false);
      
      
   SCRIPT_PutNumber( scripthandle, "Screen Setup", "ScreenWidth",ScreenWidth,false,false);
   SCRIPT_PutNumber( scripthandle, "Screen Setup", "ScreenHeight",ScreenHeight,false,false);
   SCRIPT_PutNumber( scripthandle, "Screen Setup", "ScreenMode",ScreenMode,false,false);   
   SCRIPT_PutNumber( scripthandle, "Screen Setup", "Detail",ud.detail,false,false);
   SCRIPT_PutNumber( scripthandle, "Screen Setup", "ScreenSize",ud.screen_size,false,false);   
   SCRIPT_PutNumber( scripthandle, "Screen Setup", "ScreenGamma",ud.brightness,false,false);


   SCRIPT_PutNumber( scripthandle, "Misc", "Messages",ud.fta_on,false,false);  
   SCRIPT_PutNumber( scripthandle, "Misc", "RunMode",ud.auto_run,false,false);
   SCRIPT_PutNumber( scripthandle, "Misc", "Crosshairs",ud.crosshair,false,false);
   
   // Weapon choices. 
   for(dummy=0;dummy<10;dummy++)
   {
       sprintf(buf,"WeaponChoice%ld",dummy);
       SCRIPT_PutNumber( scripthandle, "Misc",buf,ud.wchoice[myconnectindex][dummy],false,false);
   }

      
   SCRIPT_Save (scripthandle, setupfilename);
   SCRIPT_Free (scripthandle);
}

