//-------------------------------------------------------------------------
/*
Copyright (C) 1996, 2003 - 3D Realms Entertainment

This file is part of Duke Nukem 3D version 1.5 - Atomic Edition

Duke Nukem 3D is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Original Source: 1996 - Todd Replogle
Prepared for public release: 03/21/2003 - Charlie Wiederhold, 3D Realms
*/
//-------------------------------------------------------------------------

#include "duke3d.h"
#include "control.h"
#include "mouse.h"
#include "keyboard.h"

//***************************************************************************
//
// GLOBALS
//
//***************************************************************************



uint32   CONTROL_ButtonState1;
uint32   CONTROL_ButtonHeldState1;
uint32   CONTROL_ButtonState2;
uint32   CONTROL_ButtonHeldState2;


static short lastmousebuttons = 0;

static int32 mouseSensitivity = 0;



int32 MouseMapping[MAXMOUSEBUTTONS];




//***************************************************************************
//
// FUNCTIONS
//
//***************************************************************************

void CONTROL_Startup(void)
{
	KB_Startup();
    
    memset(MouseMapping, -1, sizeof(MouseMapping));
}

void CONTROL_Shutdown( void )
{
    KB_Shutdown();
}



static void SETBUTTON(int i)
{
	int b;
	
	if (i < 32) {
		b = 1 << i;
		
		CONTROL_ButtonState1 |= b;
	} else {
		i -= 32;
		
		b = 1 << i;
		
		CONTROL_ButtonState2 |= b;
	}
}

static void RESBUTTON(int i)
{
	int b;
	
	if (i < 32) {
		b = 1 << i;
		
		CONTROL_ButtonState1 &= ~b;
	} else {
		i -= 32;
		
		b = 1 << i;
		
		CONTROL_ButtonState2 &= ~b;
	}
}

void CONTROL_UpdateKeyboardState(int key, int pressed)
{
	int i;
	
	for (i = 0; i < MAXGAMEBUTTONS; i++) {
		if (KeyMapping[i].key_active == false) {
			continue;
		}
		
		if (KeyMapping[i].key1 == key || 
			KeyMapping[i].key2 == key) {
			
			if (pressed) {
				SETBUTTON(i);
			} else {
				RESBUTTON(i);
			}
		}
	}	
}

void CONTROL_MapKey( int32 which, kb_scancode key1, kb_scancode key2 )
{
	KeyMapping[which].key_active = true;
	KeyMapping[which].key1 = key1;
	KeyMapping[which].key2 = key2;
}

void CONTROL_MapButton(int32 whichfunction, int32 whichbutton)
{
    if(whichbutton < 0 || whichbutton >= MAXMOUSEBUTTONS)
	    return;

    MouseMapping[whichbutton] = whichfunction;
}







void CONTROL_GetInput(ControlInfo *info)
{
    int32 sens = CONTROL_GetMouseSensitivity();
    int mx, my;
    int i;
    short mouseButtons;
    
    memset(info, '\0', sizeof (ControlInfo));
    
    
    _handle_events();

    _getMousePosition(&mx, &my);
        
    info->dyaw = mx * sens;
    info->dz = my * sens * 4;
 

    mouseButtons = _getMouseButtons();  


    for(i=0; i<MAXMOUSEBUTTONS;++i)
    {
        if( MouseMapping[i] != -1 )
    	{
    	    if(!(lastmousebuttons & (1<<i)) && mouseButtons & (1<<i))
            {
                SETBUTTON(MouseMapping[i]);
            }
    	    else if(lastmousebuttons & (1<<i) && !(mouseButtons & (1<<i)))
            {
                RESBUTTON(MouseMapping[i]);
            }
    	}
    }
    
    lastmousebuttons = mouseButtons;
}

void CONTROL_ClearButton( int32 whichbutton )
{
	RESBUTTON(whichbutton);
}







int32 CONTROL_GetMouseSensitivity( void )
{
    return mouseSensitivity;
}

void CONTROL_SetMouseSensitivity( int32 newsensitivity )
{
	mouseSensitivity = newsensitivity;
}
















