//-------------------------------------------------------------------------
/*
Copyright (C) 1996, 2003 - 3D Realms Entertainment

This file is part of Duke Nukem 3D version 1.5 - Atomic Edition

Duke Nukem 3D is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Original Source: 1996 - Todd Replogle
Prepared for public release: 03/21/2003 - Charlie Wiederhold, 3D Realms
*/
//-------------------------------------------------------------------------

//***************************************************************************
//
// Public header for CONTROL.C.
//
//***************************************************************************

#ifndef _control_public
#define _control_public



//***************************************************************************
//
// DEFINES
//
//***************************************************************************


#define MAXGAMEBUTTONS      64
#define MAXMOUSEBUTTONS     7

#define BUTTON(x)   \
    (   \
	((x)>31) ?  \
	((CONTROL_ButtonState2>>( (x) - 32) ) & 1) :    \
	((CONTROL_ButtonState1>> (x) ) & 1) \
    )
#define BUTTONHELD(x)   \
    (   \
    ((x)>31) ?  \
    ((CONTROL_ButtonHeldState2>>((x)-32)) & 1) :    \
    ((CONTROL_ButtonHeldState1>>(x)) & 1)   \
    )
#define BUTTONJUSTPRESSED(x)    \
    ( BUTTON( x ) && !BUTTONHELD( x ) )
#define BUTTONRELEASED(x)   \
    ( !BUTTON( x ) && BUTTONHELD( x ) )
#define BUTTONSTATECHANGED(x)   \
    ( BUTTON( x ) != BUTTONHELD( x ) )

//***************************************************************************
//
// TYPEDEFS
//
//***************************************************************************


typedef struct
   {
   fixed     dx;
   fixed     dy;
   fixed     dz;
   fixed     dyaw;
   fixed     dpitch;
   } ControlInfo;



//***************************************************************************
//
// GLOBALS
//
//***************************************************************************




extern uint32   CONTROL_ButtonState1;
extern uint32   CONTROL_ButtonHeldState1;
extern uint32   CONTROL_ButtonState2;
extern uint32   CONTROL_ButtonHeldState2;


//***************************************************************************
//
// PROTOTYPES
//
//***************************************************************************
struct _KeyMapping
{
	boolean key_active;
	kb_scancode key1;
	kb_scancode key2;
} KeyMapping[MAXGAMEBUTTONS];

extern int32 MouseMapping[MAXMOUSEBUTTONS];


void CONTROL_MapKey( int32 which, kb_scancode key1, kb_scancode key2 );
void CONTROL_MapButton(int32 whichfunction, int32 whichbutton);




void CONTROL_GetInput( ControlInfo *info );
void CONTROL_ClearButton( int32 whichbutton );


int32 CONTROL_GetMouseSensitivity( void );
void CONTROL_SetMouseSensitivity( int32 newsensitivity );

void CONTROL_Startup(void);
void CONTROL_Shutdown( void );






void CONTROL_UpdateKeyboardState(int key, int pressed);

char *CONFIG_FunctionNumToName( int32 func );





#endif
