//-------------------------------------------------------------------------
/*
Copyright (C) 1996, 2003 - 3D Realms Entertainment

This file is part of Duke Nukem 3D version 1.5 - Atomic Edition

Duke Nukem 3D is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Original Source: 1996 - Todd Replogle
Prepared for public release: 03/21/2003 - Charlie Wiederhold, 3D Realms
*/
//-------------------------------------------------------------------------

#ifndef _file_lib_public
#define _file_lib_public


enum
   {
   filetype_binary,
   filetype_text
   };

enum
   {
   access_read,
   access_write,
   access_append
   };

//==========================================================================
//
// SafeOpenWrite - Opens a file for writing, returns handle
//
//==========================================================================
int32 SafeOpenWrite ( const char * filename, int32 filetype );

//==========================================================================
//
// SafeOpenRead - Opens a file for reading, returns handle
//
//==========================================================================
int32 SafeOpenRead ( const char * filename, int32 filetype );

//==========================================================================
//
// SafeOpenAppend - Opens a file for appending, returns handle
//
//==========================================================================
int32 SafeOpenAppend ( const char * filename, int32 filetype );

//==========================================================================
//
// SafeClose - Close a file denoted by the file handle
//
//==========================================================================
void SafeClose ( int32 handle );

//==========================================================================
//
// SafeFileExists - Checks for existence of file
//
//==========================================================================
boolean SafeFileExists ( const char * filename );

//==========================================================================
//
// SafeFileLength - Get length of a file pointed to by handle
//
//==========================================================================
int32 SafeFileLength ( int32 handle );

//==========================================================================
//
// SafeRead - reads from a handle
//
//            handle - handle of file to read from
//
//            buffer - pointer of buffer to read into
//
//            count  - number of bytes to read
//
//==========================================================================
void SafeRead (int32 handle, void *buffer, int32 count);

//==========================================================================
//
// SafeWrite - writes to a handle
//
//             handle - handle of file to write to
//
//             buffer - pointer of buffer to write from
//
//             count  - number of bytes to write
//
//==========================================================================
void SafeWrite (int32 handle, void *buffer, int32 count);




//==========================================================================
//
// GetPathFromEnvironment - Add a pathname described in an environment
//                          variable to a standard filename.
//
//                          fullname - final string containing entire path
//
//                          length - size of the fullname variable
//
//                          filename - standard filename
//
//==========================================================================
void GetPathFromEnvironment( char *fullname, int32 length, const char *filename );






#endif

